		--=== Hornet Gun by Qiler ===--

	--=== DEFINES===--
	RelTime	  	  		= _CurTime();
	
	--Edit this if you want
	HornetMass		 	= 1;
	SeekingRadius 	 	= 400;
	HomingForce		 	= 500;
	HitLenght		 	= 10;
	Delay			 	= 0.3;
	DelaySec		 	= 0.15
	MaxHornets 		 	= 8;
	HornetDamage	 	= 5;
	HornetDamageSec  	= 15;
	Reload 			 	= 0.6;
	StartThink	     	= 0.2;
	PrimaryShootForce	= 3000
	SecondaryShootForce = 10000
	--===============--
	
	function onInit()
		_EntFire (MyIndex,"addoutput","materialoverride models/props_foliage/oak_tree01",0)
		_EntFire (MyIndex,"color","255 150 150",0)
		
		--Loading global functions
		_RunString([[
			if not HornetLoaded then
				HornetLoaded = true;
				
				SeekingRadius 	 	= ]] .. SeekingRadius .. [[;
				HomingForce		 	= ]] .. HomingForce .. [[;
				HitLenght		 	= ]] .. HitLenght .. [[;
				HornetDamage	 	= ]] .. HornetDamage .. [[;
				HornetDamageSec  	= ]] .. HornetDamageSec .. [[;
				StartThink	     	= ]] .. StartThink .. [[;
				PrimaryShootForce	= ]] .. PrimaryShootForce .. [[;
				SecondaryShootForce	= ]] .. SecondaryShootForce .. [[;
				HornetMass			= ]] .. HornetMass .. [[;
				Time	  	  		= _CurTime();
				Hornets				= {};
				
				local NpcHeightMod = {
				"npc_alyx",
				"npc_antlionguard",
				"npc_barney",
				"npc_breen",
				"npc_citizen",
				"npc_combine_s",
				"npc_combine_e",
				"npc_turret_floor",
				"npc_dog",
				"npc_eli",
				"npc_fastzombie",
				"npc_gman",
				"npc_kleiner",
				"npc_metropolice",
				"npc_monk",
				"npc_mossman",
				"npc_poisonzombie",
				"npc_sniper",
				"npc_stalker",
				"npc_vortigaunt",
				"npc_zombie"
				}
				
				function SortEnemies (HornetID,Range,Owner)
					local EnemyTable = _EntitiesFindInSphere(_EntGetPos(HornetID),Range)
					local Enemies = {}
					local Enemy = 0;
					
					for E in EnemyTable do
						if  EnemyTable[E] ~= Owner then
							local enemy = string.lower(_EntGetType ( EnemyTable[E] ))
							
							if enemy == "player" or enemy == "env_sporeexplosion" or string.find( enemy, "npc_" ) and enemy ~= "npc_hornet" and enemy ~= "npc_grenade_frag" and enemy ~= "npc_tripmine" and enemy ~= "npc_satchel" then
								_TraceLine (_EntGetPos(HornetID), vecNormalize(vecSub( _EntGetPos(EnemyTable[E]), _EntGetPos(HornetID) )), vecLength(vecSub(_EntGetPos(EnemyTable[E]), _EntGetPos(HornetID)))+1, HornetID)
								if _TraceGetEnt() == EnemyTable[E] or enemy == "env_sporeexplosion" and vecLength(vecSub(_EntGetPos(EnemyTable[E]), _TraceEndPos())) < 5 then
									table.insert( Enemies, EnemyTable[E] );
								end
							end
						end
					end
					
					if table.getn(Enemies) > 0 then
						local Random = math.random(1,table.getn(Enemies))
						Enemy = Enemies[Random];
					end
					return Enemy;
				end
				
				function MakeTrail (Entity,color) --Trail making function, i bet you will use it :P.
					local Nade = _EntCreate("npc_grenade_frag");
					_EntSetPos( Nade, vector3(0,0,-10000) );
					_EntSpawn( Nade );
					
					local Trails =_EntitiesFindByClass("env_spritetrail");
					
					for t in Trails do
						if _EntGetParent(Trails[t]) == Nade then
							_EntSetParent( Trails[t], Entity );
							_EntFire(Trails[t],"color",color,0);
							_EntFire(Trails[t],"alpha","255",0);
							_EntRemove ( Nade );
						end
					end
				end
				
				function MakeHornet( Pos, Homing, WeaponID, Owner )
					local Hornet = _EntCreate( "prop_physics" );
					
					local RandomColor = ("255 "..math.random(0,80).." 0")
					
					MakeTrail(Hornet,RandomColor)
					MakeTrail(Hornet,RandomColor)
					MakeTrail(Hornet,RandomColor)
					
					_EntSetOwner( Hornet, Owner );
					_PhysSetMass( Hornet, HornetMass );
					_EntSetPos( Hornet, Pos );
					_EntSetKeyValue( Hornet, "rendermode", 10 );
					_EntSetKeyValue( Hornet, "angles", math.random(0,360).." "..math.random(0,360).." "..math.random(0,360) );
					_EntSetKeyValue( Hornet, "model", "models/props_junk/watermelon01_chunk02c.mdl" );
					_EntSetKeyValue( Hornet, "spawnflags", "512" );
					_EntSetKeyValue( Hornet, "classname", "npc_hornet");
					_EntSetParent( trail, particle);
					_EntSetMoveCollide( Hornet, 3 );
					_EntSpawn( Hornet );
					_phys.EnableGravity( Hornet, false );
					_phys.EnableDrag( Hornet, false );
					
					_EntFire( Hornet,"addoutput","onhealthchanged !self,kill,1,1",0 )
					_EntFire( Hornet,"addoutput","physdamagescale 1000",0 )
					_EntFire( Hornet,"kill","1", 5 )
					
					local PlayerAng = _PlayerGetShootAng( Owner )
					
					local Htable 			= {}
					Htable.Id 				= Hornet;
					Htable.Enemy			= 0;
					Htable.Owner 			= Owner;
					Htable.WeaponID			= WeaponID
					Htable.StartThink		= _CurTime() + StartThink;
					Htable.LastPos 			= vecAdd( Pos, vecMul( vector3( PlayerAng.x, PlayerAng.y, PlayerAng.z ), vector3(-10,-10,-10) ) );
					Htable.Homing 			= Homing;
					table.insert( Hornets, Htable );
					
					return Hornet;
				end
				
				function FireHornet ( Owner, WeaponID, Homing )
					if Homing then
						local HornetSpawnPos = vecAdd( vecAdd( _PlayerGetShootPos( Owner ), vecMul( _EntGetRightVector( Owner ), 10 ) ), vecMul( _EntGetUpVector( Owner ), -17 ) )
						local Hornet = MakeHornet( HornetSpawnPos, true, WeaponID, Owner )
						_TraceLine ( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 2000, Owner);
						local ShootAng = vecNormalize(vecSub( _TraceEndPos(), HornetSpawnPos ));
						_PhysApplyForce( Hornet, vecMul( vecAdd(  ShootAng , vector3((math.random()-0.5)/15, (math.random()-0.5)/15, (math.random()-0.5)/15)), vector3(PrimaryShootForce, PrimaryShootForce, PrimaryShootForce) ) )
						_PhysSetMass( Hornet, HornetMass );
					else
						local HornetSpawnPos = vecAdd( vecAdd( _PlayerGetShootPos( Owner ), vecMul( _EntGetRightVector( Owner ), 10 ) ), vecMul( _EntGetUpVector( Owner ), -17 ) )
						local Hornet = MakeHornet( HornetSpawnPos, false, WeaponID, Owner )
						_TraceLine ( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 2000, Owner);
						local ShootAng = vecNormalize(vecSub( _TraceEndPos(), HornetSpawnPos ));
						_PhysApplyForce( Hornet, vecMul( vecAdd(  ShootAng , vector3((math.random()-0.5)/30, (math.random()-0.5)/30, (math.random()-0.5)/30)), vector3(SecondaryShootForce, SecondaryShootForce, SecondaryShootForce) ) )
						_PhysSetMass( Hornet, HornetMass );
					end
				end
				
				function HornetThink ()
					local CurTime = _CurTime();
					for i in Hornets do
						if Hornets[i].Enemy ~= nil then
							if not _EntExists ( Hornets[i].Enemy ) then
								Hornets[i].Enemy = 0;
							end
						end
						if not _EntExists ( Hornets[i].Id ) or string.lower(_EntGetType( Hornets[i].Id )) ~= "npc_hornet" then
							table.remove( Hornets, i );
						end
					end
					
					if CurTime > Time then
						for H in Hornets do
							if Hornets[H] ~= nil then
								if _EntExists ( Hornets[H].Id ) then
									if Hornets[H].StartThink <= _CurTime() then
										if Hornets[H].Enemy == 0 or Hornets[H].Enemy == nil or not _EntExists (Hornets[H].Enemy) then
											Hornets[H].Enemy = SortEnemies (Hornets[H].Id,SeekingRadius,Hornets[H].Owner);
										end
									end
									
									local EnemyPos = vector3(0,0,0)
									if Hornets[H].Enemy ~= 0 and Hornets[H].Enemy ~= nil then
										EnemyPos = _EntGetPos(Hornets[H].Enemy)
										if _EntGetType ( Hornets[H].Enemy ) == "player" then
											if not _PlayerIsKeyDown ( Hornets[H].Enemy, 4 ) then
												EnemyPos.z = EnemyPos.z + 32;
											else
												EnemyPos.z = EnemyPos.z + 16
											end
										else
											for npc in NpcHeightMod do
												if _EntGetType ( Hornets[H].Enemy ) == NpcHeightMod[npc] then
													EnemyPos.z = EnemyPos.z + 32;
												end
											end
										end
									end
									
									if Hornets[H].Enemy ~= 0  and Hornets[H].Enemy ~= nil and Hornets[H].Homing then
										_TraceLine (_EntGetPos(Hornets[H].Id), vecNormalize(vecSub( EnemyPos, _EntGetPos(Hornets[H].Id) )), SeekingRadius, Hornets[H].Id)
										if _TraceGetEnt() == Hornets[H].Enemy or _EntGetType (Hornets[H].Enemy) == "env_sporeexplosion" or string.find(_EntGetType (_TraceGetEnt()), "prop_vehicle_") and _EntGetType (Hornets[H].Enemy) == "player" then
											local AntiOrbitForce = math.random(0,200);
											_PhysApplyForce(Hornets[H].Id, vecMul( vecNormalize(vecSub( EnemyPos, _EntGetPos(Hornets[H].Id) )), vector3(HomingForce + AntiOrbitForce, HomingForce + AntiOrbitForce, HomingForce + AntiOrbitForce)))
											if vecLength(vecSub(_EntGetPos(Hornets[H].Id), _TraceEndPos())) < 10 then
												_TraceAttack( _TraceGetEnt(), Hornets[H].WeaponID, Hornets[H].Owner, HornetDamage );
												_EntRemove ( Hornets[H].Id );
											end
										else
											Hornets[H].Enemy = 0;
										end
									end
									
									local HornetPos = _EntGetPos(Hornets[H].Id)
									if Hornets[H].LastPos.x ~= HornetPos.x and Hornets[H].LastPos.y ~= HornetPos.y and Hornets[H].LastPos.z ~= HornetPos.z then
										_TraceLine ( _EntGetPos(Hornets[H].Id), vecNormalize(vecSub( _EntGetPos(Hornets[H].Id), Hornets[H].LastPos )), HitLenght, Hornets[H].Id);	
										if _TraceHit() and _TraceHitNonWorld() then
											if Hornets[H].Homing then
												_TraceAttack( _TraceGetEnt(), Hornets[H].WeaponID, Hornets[H].Owner, HornetDamage );
											else
												_TraceAttack( _TraceGetEnt(), Hornets[H].WeaponID, Hornets[H].Owner, HornetDamageSec );
											end
											_EntRemove ( Hornets[H].Id );
										end
									end
									Hornets[H].LastPos = _EntGetPos(Hornets[H].Id)
									
									if math.random( 0, 10 ) == 5 then 
										_EntEmitSoundEx( Hornets[H].Id, "ambient/creatures/flies"..math.random(1,3)..".wav", 1, 1 ); 
									end
								end
							end
						end
						Time = _CurTime()
					end
				end
				AddThinkFunction(HornetThink)
			end
		]])
	end
	
	function onThink()
		local CurTime = _CurTime();
		
		if RelTime <= _CurTime() then
			if _swep.GetClipAmmo( MyIndex, 0 ) < MaxHornets then
				_swep.SetClipAmmo( MyIndex, 0, _swep.GetClipAmmo( MyIndex, 0 ) + 1 );
			end
			RelTime = _CurTime() + Reload;
		end
	end

	
	function onPrimaryAttack( )
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
		_EntEmitSoundEx(Owner, "weapons/ag_fire2.wav", 0.65, 1);
		
		_RunString("FireHornet( " .. Owner ..",".. MyIndex ..", true )")
		
		_SWEPUseAmmo(MyIndex, 0, 1);
	end

	function onSecondaryAttack()
		if ( _PlayerInfo( Owner, "alive" ) == false ) or _swep.GetClipAmmo( MyIndex, 0 ) == 0 then return; end
		_EntEmitSoundEx(Owner, "weapons/ag_fire2.wav", 0.65, 1);
		
		_RunString("FireHornet( " .. Owner ..",".. MyIndex ..", false )")
		
		_SWEPUseAmmo(MyIndex, 0, 1);
	end
	
	function Holster()
		if _swep.GetClipAmmo( MyIndex, 0 ) == 0 then
			_swep.SetClipAmmo( MyIndex, 0, 1 )
		end
	end

	function Deploy()
		_EntFire (MyIndex,"addoutput","materialoverride models/props_foliage/oak_tree01",0)
		_EntFire (MyIndex,"color","255 150 150",0)
	end
	
	function onDrop()
		_EntFire (MyIndex,"addoutput","materialoverride models/props_foliage/oak_tree01",0)
		_EntFire (MyIndex,"color","255 150 150",0)
	end
	
	function onReload()
	   return false;
	end

	function getWeaponSwapHands()
		return false;	
	end
	
	function getViewKick()
		return vector3( 0.1, 0.1, 0.1);
	end

	function getViewKickRandom()
		return vector3( 0.1, 0.1, 0.1 );
	end
	
	function getViewKickSecondary()
		return vector3( 0.1, 0.1, 0.1);
	end

	function getViewKickRandomSecondary()
		return vector3( 0.1, 0.1, 0.1 );
	end

	function getWeaponFOV()
		return 65;	
	end


	function getWeaponSlot()
		return 5;	
	end

	function getWeaponSlotPos()
		return 7;	
	end

	function getFiresUnderwater()
		return true;
	end

	function getReloadsSingly()
		return false;
	end

	function getDamage()
		return 0;
	end

	function getPrimaryShotDelay()
		return Delay;
	end

	function getSecondaryShotDelay()
		return DelaySec;
	end

	function getPrimaryIsAutomatic()
		return true;
	end

	function getSecondaryIsAutomatic()
		return true;
	end

	function getPrimaryAmmoType()
		return "AirboatGun";
	end

	function getSecondaryAmmoType()
		return "none";
	end

	function getMaxClipPrimary()
		return MaxHornets;
	end

	function getMaxClipSecondary()
		return -1;
	end

	function getDefClipPrimary()
		return MaxHornets;
	end

	function getDefClipSecondary()
		return 0;
	end

	function getPrimaryScriptOverride()
		return 2;
	end

	function getSecondaryScriptOverride()
		return 2;
	end

	function getViewModel( )
		return "models/v_hgun.mdl";
	end

	function getWorldModel()
		return "models/weapons/w_irifle.mdl";
	end

	function getWeaponFOV()
		return 80;	
	end
	
	function getClassName()
		return "weapon_HornetGun";
	end

	function getAnimPrefix()
		return "ar2";
	end
	
	function getHUDMaterial()
		return "decals/alienflesh/shot1";
	end

	function getPrintName()
		return "Hornet Gun";
	end